<!DOCTYPE html>
<!--[if lt IE 7]> <html dir="ltr" lang="en-US" class="ie6"> <![endif]-->
<!--[if IE 7]>    <html dir="ltr" lang="en-US" class="ie7"> <![endif]-->
<!--[if IE 8]>    <html dir="ltr" lang="en-US" class="ie8"> <![endif]-->
<!--[if gt IE 8]><!--> <html dir="ltr" lang="en-US"> <!--<![endif]-->

<!-- BEGIN head -->
<head>

	<!--Meta Tags-->
	<meta name="viewport" content="width=device-width; initial-scale=1.0">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		
	<!--Title-->
	<title>Xuân Phú Hotel - Khách Sạn Xuân Phú</title>

	<!--Stylesheets-->
	<link rel="stylesheet" href="<?php echo e(Asset('public/template/css/superfish.css')); ?>" type="text/css"  media="all"  />
	<link rel="stylesheet" href="<?php echo e(Asset('public/template/css/prettyPhoto.css')); ?>" type="text/css" media="all" />
	<link type="text/css"  href="<?php echo e(Asset('public/template/css/jqueryui/jquery.ui.datepicker.css')); ?>" rel="stylesheet" />
	<link rel="stylesheet" href="<?php echo e(Asset('public/template/style.css')); ?>" type="text/css"  media="all"  />
	<link rel="stylesheet" href="<?php echo e(Asset('public/template/css/colours/cream-red.css')); ?>" type="text/css"  media="all"  />
	<link href='http://fonts.googleapis.com/css?family=Cardo:400,400italic,700' rel='stylesheet' type='text/css'>

	<!--Favicon-->
	<link rel="shortcut icon" href="favicon.ico" type="image/x-icon" />

	<!--JavaScript-->
	<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.7/jquery.min.js"></script>
	<script type='text/javascript' src='http://ajax.googleapis.com/ajax/libs/jqueryui/1.8/jquery-ui.min.js'></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/jquery.ui.core.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/jquery.ui.widget.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/jquery.ui.datepicker.js')); ?>"></script>
	<script type='text/javascript' src="<?php echo e(Asset('public/template/js/jquery.prettyPhoto.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/superfish.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/slides.min.jquery.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/scripts.js')); ?>"></script>
	
	<!--[if (gte IE 6)&(lte IE 8)]>
		<script type="text/javascript" src="js/selectivizr-min.js"></script>
	<![endif]-->

<!-- END head -->
</head>

<!-- BEGIN body -->
<body>

	<!-- BEGIN .background-wrapper -->
	<div class="background-wrapper">
		
		<!-- BEGIN .content-wrapper -->
		<div class="content-wrapper">
		
			<!-- BEGIN .content-body -->
			<div class="content-body">
				
				<!-- BEGIN #header-google-map -->
				<div id="header-google-map" style="display:none;">
					<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=false"></script>
					<script type="text/javascript" src="<?php echo e(Asset('public/template/js/gmap.js')); ?>"></script>
					<div id="map_canvas" style="width:100%;height:300px;"></div>
				<!-- END #header-google-map -->
				</div>
				
				<!-- BEGIN .top-bar -->
				<div class="top-bar clearfix">
					
					<!-- BEGIN .social-icons -->
					<ul class="social-icons fl">
						<li><a href="#"><span id="facebook_icon"></span></a></li>
						<li><a href="#"><span id="googleplus_icon"></span></a></li>
						<li><a href="#"><span id="skype_icon"></span></a></li>
						<li><a href="#"><span id="flickr_icon"></span></a></li>
					<!-- END .social-icons -->
					</ul>
					
					<!-- BEGIN .gmap-btn-wrapper -->
					<div class="gmap-btn-wrapper">
						<a href="#" class="gmap-btn"></a>
						<div class="gmap-curve"></div>
					<!-- END .gmap-btn-wrapper -->
					</div>
					
					<!-- BEGIN .top-menu-wrapper -->
					<div class="top-menu-wrapper fr clearfix">
						<a href="accommodation.html" class="bookbutton">Book Now</a>
						<!-- <ul class="top-menu fr">
							<li><a href="#">En</a><span> /</span></li>
							<li><a href="#">Fr</a></li>
						</ul> -->
					<!-- END .top-menu-wrapper -->
					</div>
					
				<!-- END .top-bar -->
				</div>
				
				<!-- BEGIN .title-wrapper -->
				<div id="title-wrapper">
					<h1><div class="title-dec-left"></div><a href="index.html">Xuân Phú Hotel <span>Khách Sạn Xuân Phú</span></a><div class="title-dec-right"></div></h1>
				<!-- END .title-wrapper -->
				</div>
				
				<!-- BEGIN #navigation -->
				<div id="navigation" class="clearfix">
					
					<!-- BEGIN #main-menu -->
					<ul id="main-menu" class="fl clearfix">
						<li><a href="index.html">Trang chủ<span>start here</span></a></li>
						<li><a href="accommodation.html">Loại phòng<span>rates &amp; reservations</span></a>
							<ul>
								<li><a href="accommodation-single.html">Single Standard Room</a></li>
								<li><a href="accommodation-single.html">Double Standard Room</a></li>
								<li><a href="accommodation-single.html">Single Ensuite Room</a>
									<ul>
										<li><a href="accommodation-single.html">Single Standard Room</a></li>
										<li><a href="accommodation-single.html">Double Standard Room</a></li>
										<li><a href="accommodation-single.html">Single Ensuite Room</a>
									</ul>
								</li>
								<li><a href="accommodation-single.html">Double Ensuite Room</a></li>
							</ul>
						</li>
						<li><a href="<?php echo e(Asset('home/explore')); ?>">Khám phá Đà Nẵng<span>explore Da Nang</span></a>
							<ul>
								<li><a href="blog-single.html">Tin tức & Sự kiện</a></li>
								<li><a href="blog-single.html">Quán ngon Đà Thành</a></li>
								<li><a href="gallery.html">Thư viện Hình ảnh</a>	
							</ul>
						</li>
						<li><a href="<?php echo e(Asset('home/event')); ?>">Khuyến mãi<span>what's happening</span></a></li>
						<li class="current-menu-item"><a href="<?php echo e(Asset('home/contact')); ?>">Liên hệ<span>get in touch</span></a></li>
					<!-- END #main-menu -->
					</ul>
					
					<ul class="main-menu-contact-info fr">
						<li class="info-phone">05113.66.88.16</li>
						<li class="info-email">maixphu@gmail.com</li>
					</ul>
					
					<div class="corner-left"></div>
					<div class="corner-right"></div>
					
				<!-- END #navigation -->
				</div>
				
				<!-- BEGIN .page-header -->
				<div class="page-header">
					<img src="<?php echo e(Asset('public/template/images/page-head-1.jpg')); ?>" alt="" />
				<!-- END .page-header -->
				</div>
				
				<!-- BEGIN .section -->
				<div class="section clearfix">
					
					<!-- BEGIN .main-content -->
					<div class="main-content">
						
						<h2 class="page-title"><?php echo $__env->yieldContent('title'); ?></h2>
						
						<?php echo $__env->yieldContent('content'); ?>
					
					<!-- END .main-content -->
					</div>
					
					<!-- BEGIN .sidebar -->
					<div class="sidebar last-col">
						
						<div class="widget">
						<div class="widget-title clearfix"><h5>Search</h5></div>
							<form method="get" action="#" class="search">
								<input type="text" onblur="if(this.value=='')this.value='Search...';" onfocus="if(this.value=='Search...')this.value='';" value="Search..." name="s" />
							</form>
						</div>
						
						<div class="widget">
							<div class="widget-title clearfix"><h5>Danh mục</h5></div>
							<ul>
								<?php foreach(App\Category::all() as $category): ?>
								<li><a href="#"><?php echo e($category -> name); ?></a></li>
								<?php endforeach; ?>								
							</ul>
						</div>					
												
						<div class="widget">
							<div class="widget-title clearfix"><h5>Bài viết mới nhất</h5></div>
							
							<ul class="latest-posts-list clearfix">
								
								<li class="clearfix">
									<div class="lpl-img">
										<a href="#" rel="bookmark">
											<img width="66" height="66" src="images/image2.png" alt="" />
										</a>
									</div>
									<div class="lpl-content">
										<h6><a href="#" rel="bookmark">Dasellus ac nibh urna donec 
										ac urna</a> <span> Posted Jun 13, 2012 By admin</span></h6>
									</div>
								</li>
								
								<li class="clearfix">
									<div class="lpl-img">
										<a href="#" rel="bookmark">
											<img width="66" height="66" src="images/image2.png" alt="" />
										</a>
									</div>
									<div class="lpl-content">
										<h6><a href="#" rel="bookmark">Dasellus ac nibh urna donec 
										ac urna</a> <span> Posted Jun 13, 2012 By admin</span></h6>
									</div>
								</li>
								
								<li class="clearfix">
									<div class="lpl-img">
										<a href="#" rel="bookmark">
											<img width="66" height="66" src="images/image2.png" alt="" />
										</a>
									</div>
									<div class="lpl-content">
										<h6><a href="#" rel="bookmark">Dasellus ac nibh urna donec 
										ac urna</a> <span> Posted Jun 13, 2012 By admin</span></h6>
									</div>
								</li>
								
							</ul>
						
						</div>
						
						<div class="widget">
							<div class="widget-title clearfix"><h5>Đặt phòng</h5></div>
							
							<!-- BEGIN .booknow-sidebar -->
							<div class="booknow-sidebar">
							
								<!-- BEGIN .booknow -->
								<div class="booknow">

									<form class="booking-form" name="bookroom" action="#" method="post">

										<div class="select-wrapper">
											<select id="room" name="room">
												<option>Select a Room...</option>
												<option>Single Standard Room</option>
												<option>Double Standard Room</option>
												<option>Single Ensuite Room</option>
												<option>Double Ensuite Room</option>
											</select>
										</div>

										<div class="clearfix">
											<input type="text" id="datefrom" value="From" class="input-half datepicker">
											<input type="text" id="dateto" value="To" class="input-half input-half-last datepicker">
										</div>

										<input class="bookbutton" type="submit" value="Book Now" />

									</form>

									<div class="corner-left"></div>
								
								<!-- END .booknow -->
								</div>
							
							<!-- END . booknow-sidebar -->
							</div>
							
						</div>
						
					<!-- END .sidebar -->
					</div>
				
				<!-- END .section -->
				</div>
				
				<!-- BEGIN #footer -->
				<div id="footer" class="clearfix">
					
					<!-- BEGIN .two-forths -->
					<div class="two-forths">
						
						<!-- BEGIN .widget -->
						<div class="widget">
							<div class="widget-title clearfix">
								<h5>Nice Hotel</h5>
							</div>
							<p>Pellentesque dignissim porta enim, eget commodo metus euismod id. Suspendisse congue, ligula ac accumsan vestibulum, nisi mauris aliquet quam, in facilisis felis tortor eu dui. Vivamus augue elit, viverra id congue ut, accumsan in dolor. Nulla id risus sit amet nisl euismod egestas non eget dolor. Aliquam in dui diam</p>
						<!-- END .widget -->
						</div>
					
					<!-- END .two-forths -->
					</div>
					
					<!-- BEGIN .one-forth -->
					<div class="one-forth">
						
						<!-- BEGIN .widget -->
						<div class="widget">
							<div class="widget-title clearfix">
								<h5>Site Map</h5>
							</div>
							
							<ul>
								<li><a href="accommodation.html">Accommodation</a></li>
								<li><a href="typography.html">Facilities</a></li>
								<li><a href="events.html">Events</a></li>
								<li><a href="contact.html">Contact</a></li>
							</ul>
							
						<!-- END .widget -->
						</div>
					
					<!-- END .one-forth -->
					</div>
					
					<!-- BEGIN .one-forth -->
					<div class="one-forth last-col">
						
						<!-- BEGIN .widget -->
						<div class="widget">
							<div class="widget-title clearfix">
								<h5>Flickr</h5>
							</div>
							
							<div class="flickr_badge_wrapper clearfix">
								<script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?count=6&amp;flickr_display=latest&amp;size=s&amp;layout=x&amp;source=user&amp;user=65744139@N04"></script>
								<div style="clear:both;"></div>
								<p class="flickr-more-photos"><a href="http://www.flickr.com/photos/65744139@N04">View More &raquo;</a></p>
							</div>
							
						<!-- END .widget -->
						</div>
						
					<!-- END .one-forth -->
					</div>
					
				<!-- END #footer -->
				</div>
				
				<!-- BEGIN #footer-bottom -->
				<div id="footer-bottom" class="clearfix">
					<p class="fl">&copy; Copyright 2012</p>
					<ul class="footer-menu fr">
						<li><a href="index.html">Home</a><span>/</span></li>
						<li><a href="accommodation.html">Book</a><span>/</span></li>
						<li><a href="contact.html">Contact</a><span>/</span></li>
					</ul>
				<!-- END #footer-bottom -->
				</div>
			
			<!-- END .content-body -->
			</div>
			
		<!-- END .content-wrapper -->
		</div>
		
	<!-- END .background-wrapper -->
	</div>

<!-- END body -->
</body>
</html>