

<?php $__env->startSection('title'); ?>
<?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row">    
    <div class="col-lg-12">
        <div class="panel panel-default">
            <div class="panel-heading">Lists in All Bookings</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <div class="table-responsive">
                    <table class="table table-hover table-condensed">
                        <thead>
                            <tr>
                                <th>Fullname</th>
                                <th>From</th>
                                <th>To</th>
                                <th>Room Type</th>
                                <th>People</th>
                                <th>Phone</th>
                                <th>Email</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        	<?php foreach($orders as $order): ?>
                            <tr>
                                <td><?php echo e($order -> fullname); ?></td>
                                <td><?php echo e($order -> datefrom); ?></td>
                                <td><?php echo e($order -> dateto); ?></td>
                                <td><?php echo e(App\Room::find($order -> room_id) ->name); ?></td>
                                <td><?php echo e($order -> people); ?></td>
                                <td><?php echo e($order -> phone); ?></td>
                                <td><?php echo e($order -> email); ?></td>
                                <td>
									<?php if($order -> active): ?>
                                        <a href='active/<?php echo e($order -> id); ?>' class='btn btn-success btn-xs' data-toggle="tooltip" data-placement="top" title="OFF"><i class='fa fa-refresh'></i></a>
                                    <?php else: ?>
                                        <a href='active/<?php echo e($order -> id); ?>' class='btn btn-default btn-xs' data-toggle="tooltip" data-placement="top" title="ON"><i class='fa fa-refresh'></i></a>
                                    <?php endif; ?>
									<a href='destroy/<?php echo e($order -> id); ?>' class='btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a>
								</td>                               
                            </tr>
                            <?php endforeach; ?>                            
                        </tbody>
                    </table>
                </div>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('template.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>