

<?php $__env->startSection('title'); ?>
<?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Create</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
				<form role="form" method="post" action="<?php echo e(Asset('admin/items/create')); ?>">
					<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">						
					<div class="row">
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label>Room Type</label>
                                <select class="form-control" name="room_id">                     
                                <?php foreach($roomtypes as $id => $name): ?>                        
                                <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                <?php endforeach; ?>    
                            </select>
                            </div>
                        </div>
                        <div class="col-lg-8">
                            <div class="form-group">
                                <label>Name</label>
                                <input class="form-control" name="name">
                            </div>
                        </div>           
                    </div>   
                      
                    <div class="form-group">
                        <label>Note</label>
                        <textarea class="form-control" rows="5" name="note"></textarea>
                    </div>                                      
					<button type="submit" class="btn btn-default">Submit</button>
				</form>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Items</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <div class="table-responsive">
                    <table class="table table-hover table-condensed">
                        <thead>
                            <tr>
                                <th>#</th>                                
                                <th>Room Type</th>
                                <th>Room</th>
                                <th>Price</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        	<?php foreach($items as $item): ?>
                            <tr>
                                <td><?php echo e($item -> id); ?></td>                               
                                <td><?php echo e(App\Room::find($item -> room_id)->name); ?></td>
                                <td><?php echo e($item -> name); ?></td>
                                <td><?php echo e($item -> price); ?></td>                                
                                <td><?php echo e(date('d-m-Y', strtotime($item -> created_at))); ?></td>
                                <td>
									<?php if($item -> active): ?>
                                        <a href='active/<?php echo e($item -> id); ?>' class='btn btn-success btn-xs' data-toggle="tooltip" data-placement="top" title="OFF"><i class='fa fa-refresh'></i></a>
                                    <?php else: ?>
                                        <a href='active/<?php echo e($item -> id); ?>' class='btn btn-default btn-xs' data-toggle="tooltip" data-placement="top" title="ON"><i class='fa fa-refresh'></i></a>
                                    <?php endif; ?>
									<a href='edit/<?php echo e($item -> id); ?>' class='btn btn-primary btn-xs'><i class='fa fa-edit'></i></a>
									<a href='destroy/<?php echo e($item -> id); ?>' class='btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a>
								</td>                               
                            </tr>
                            <?php endforeach; ?>                            
                        </tbody>
                    </table>
                    <?php echo e($items -> links()); ?>

                </div>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('template.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>