<?php $__env->startSection('title'); ?>
PostID: <?php echo e($post -> id); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-lg-12">
        <?php if(count($errors) > 0): ?>
            <div class="alert alert-warning" role="alert">
                <?php foreach($errors->all() as $error): ?>
                    <?php echo e($error); ?>

                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <div class="panel panel-default">
            <div class="panel-heading">Edit</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <div class="table-responsive">
					<form role="form" method="post" action="<?php echo e(Asset('admin/posts/edit')); ?>/<?php echo e($post->id); ?>">
						<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
						<div class="form-group">
                            <label>Category</label>
                            <select class="form-control" name="category_id">                     
                                <?php foreach($categories as $id => $name): ?>  
                                <?php if($id == $post->category_id): ?>)
                                    <option value='<?php echo e($id); ?>' selected="selected"> <?php echo e($name); ?></option>
                                <?php else: ?>
                                    <option value='<?php echo e($id); ?>' > <?php echo e($name); ?></option>
                                <?php endif; ?>
                                <?php endforeach; ?>    
                            </select>
						</div>
                        <div class="form-group">                            
                            <label>Title</label>
                            <input class="form-control" name="title" value="<?php echo e($post->title); ?>">
                        </div>
                        <div class="form-group">
                            <label>Image</label>
                            <input class="form-control" name="image" value="<?php echo e($post->image); ?>">
                        </div>
                        <div class="form-group">
                            <label>Description</label>
                            <textarea name="description" class="form-control" rows="9"><?php echo e($post->description); ?></textarea>
                        </div>
						<button type="submit" class="btn btn-default">Submit</button>
					</form>
                </div>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->    
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('template.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>