@extends('template.admin')

@section('title')
RoomID: {{$room -> id}}
@stop

@section('content')
<div class="row">
    <div class="col-lg-12">
        @if (count($errors) > 0)
            <div class="alert alert-warning" role="alert">
                @foreach ($errors->all() as $error)
                    {{ $error }}
                @endforeach
            </div>
        @endif
        <div class="panel panel-default">
            <div class="panel-heading">Edit</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
					<form role="form" method="post" action="{{Asset('admin/rooms/edit')}}/{{$room->id}}">
						<input type="hidden" name="_token" value="{{ csrf_token() }}">
						<div class="form-group">
							<label>Name</label>
							<input class="form-control" name="name" value="{{$room->name}}">
						</div>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>Price</label>
                                    <input class="form-control" name="price" value="{{$room->price}}">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>People</label>
                                    <input class="form-control" name="people" value="{{$room->people}}">
                                </div>
                            </div>
                        </div>                        
                        <div class="form-group">
                            <label>Description</label>
                            <textarea class="form-control" rows="5" name="description">{{$room->description}}</textarea>
                        </div>
                        <div class="form-group">
                            <label>Image</label>
                            <textarea class="form-control" rows="3" name="image">{{$room->image}}</textarea>
                        </div>                        
						<button type="submit" class="btn btn-default">Submit</button>
					</form>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->    
</div>
@stop