
<?php $__env->startSection('title'); ?>
	<?php echo e($title); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<style>
	.loading {
		width: 24px;
		height: 24px;
		float: right;
	}
	.active {
		
	}
	.inactive {
		color:gray;
	}
</style>

<script src="http://code.jquery.com/jquery-1.11.1.min.js"></script>
<script type="text/javascript">
    $(document).ready(function(){
        $("input[name^='active']").change(function(){ 
        	var parent = $(this).parent();
        	var price = parent.children('span').eq(0);
        	var loading = parent.children('div').eq(0);
        	loading.show();

        	var roomId = $(this).attr("roomId");
        	var facilityId = $(this).attr("facilityId");
        	var checked = $(this).prop('checked');
    		var token = $('input[name="_token"]').val(); 
        	var content = "roomId="+roomId+"&facilityId="+facilityId+"&checked="+checked+"&_token="+token;   
        	jQuery.ajax({
                type: "GET", // HTTP method POST or GET
                url: "<?php echo e(Asset('admin/roomfacilities/active-ajax')); ?>", //Where to make Ajax calls
                dataType: 'json',
                data: content, //post variables
                success:function(response) {
                	if (response.success) {
                		if (checked == true) {
	                		parent.removeClass("warning");	
	                		parent.addClass("info");
	                		price.removeClass("inactive");	
	                		price.addClass("active");
	                	} else {
	                		parent.removeClass("info");
	                		parent.addClass("warning");
	                		price.removeClass("active");	
	                		price.addClass("inactive");	
	                	}
                	} else {
	                	alert("Something's wrong");
                	}
                	loading.hide();
                },
                error:function (xhr, ajaxOptions, thrownError){
                    alert(thrownError); //throw any errors
                    loading.hide();
                }
			});
        });
    });
</script>

<?php if(empty($matrix)): ?>
Null
<?php else: ?>
<div class="list-group">
	<table class="table table-bordered">
		<tr>
			<td></td>	
			<?php foreach($rooms as $room): ?>
				<th class="text-center" roomId="<?php echo e($room -> id); ?>"><?php echo e($room->name); ?></th>
			<?php endforeach; ?>
		</tr>

	<?php foreach($facilities as $facility): ?>
		<?php if($facility -> active): ?>
			<tr>
		<?php else: ?>
			<tr class="danger">
		<?php endif; ?>		
			<td><?php echo e($facility ->name); ?></td>
			<?php foreach($rooms as $room): ?>	
			<?php echo e(csrf_field()); ?>			
				<?php if($matrix[$room -> id][$facility -> id]): ?>
					<?php if($matrix[$room -> id][$facility -> id] -> active): ?>
						<!-- Setted and Actived -->
						<td class='info text-center' id="td-<?php echo e($room -> id); ?>-<?php echo e($facility -> id); ?>">
							<input type="checkbox" name="active" roomId="<?php echo e($room -> id); ?>" facilityId="<?php echo e($facility -> id); ?>" value="1" checked="checked"/>
							<span class="active"></span>
							<div class="loading" style="display:none">
								<img src="https://storefront.kelsan.biz/storefrontCommerce/images/infor_ajax-loader_24x24.gif">
							</div>
						</td>
					<?php else: ?>
						<!-- Setted but Not Actived -->
						<td class='warning text-center' id="td-<?php echo e($room -> id); ?>-<?php echo e($facility -> id); ?>">
							<input type="checkbox" name="active" roomId="<?php echo e($room -> id); ?>" facilityId="<?php echo e($facility -> id); ?>" value="0"/>
							<span class="inactive"></span>
							<div class="loading" style="display:none">
								<img src="https://storefront.kelsan.biz/storefrontCommerce/images/infor_ajax-loader_24x24.gif">
							</div>
						</td>
					<?php endif; ?>					
				<?php else: ?>
					<td class='text-center' id="td-<?php echo e($room -> id); ?>-<?php echo e($facility -> id); ?>">
						<input type="checkbox" name="active" roomId="<?php echo e($room -> id); ?>" facilityId="<?php echo e($facility -> id); ?>" value="-1"/>
						<span></span>
						<div class="loading" style="display:none">
								<img src="https://storefront.kelsan.biz/storefrontCommerce/images/infor_ajax-loader_24x24.gif">
							</div>
					</td>
				<?php endif; ?>
			<?php endforeach; ?>
		</tr>
	<?php endforeach; ?>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('template.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>