<?php $__env->startSection('title'); ?>
<?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Create</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <div class="table-responsive">
					<form role="form" method="post" action="<?php echo e(Asset('admin/posts/create')); ?>">
						<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
						<div class="form-group">
                            <label>Category</label>
                            <select class="form-control" name="category_id">                     
                                <?php foreach($categories as $id => $name): ?>                        
                                <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                <?php endforeach; ?>    
                            </select>
						</div>
                        <div class="form-group">                            
                            <label>Title</label>
                            <input class="form-control" name="title">
                        </div>
                        <div class="form-group">
                            <label>Image</label>
                            <input class="form-control" name="image">
                        </div>
                        <div class="form-group">
                            <label>Description</label>
                            <textarea name="description" class="form-control" rows="9"></textarea>                            
                        </div>                       
						<button type="submit" class="btn btn-default">Submit</button>
					</form>
                </div>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
    <div class="col-lg-6">
        <div class="panel panel-default">
            <div class="panel-heading">Posts</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <div class="table-responsive">
                    <table class="table table-hover table-condensed">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Title</th>
                                <th>Category</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        	<?php foreach($posts as $post): ?>
                            <tr>
                                <td><?php echo e($post -> id); ?></td>
                                <td><?php echo e($post -> title); ?></td>
                                <td><?php if(App\Category::find($post -> category_id)): ?> <?php echo e(App\Category::find($post -> category_id) -> name); ?> <?php else: ?> Unknow <?php endif; ?></td>
                                <td>
									<?php if($post -> active): ?>
                                        <a href='active/<?php echo e($post -> id); ?>' class='btn btn-success btn-xs' data-toggle="tooltip" data-placement="top" title="OFF"><i class='fa fa-refresh'></i></a>
                                    <?php else: ?>
                                        <a href='active/<?php echo e($post -> id); ?>' class='btn btn-default btn-xs' data-toggle="tooltip" data-placement="top" title="ON"><i class='fa fa-refresh'></i></a>
                                    <?php endif; ?>
									<a href='edit/<?php echo e($post -> id); ?>' class='btn btn-primary btn-xs'><i class='fa fa-edit'></i></a>
									<a href='destroy/<?php echo e($post -> id); ?>' class='btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a>
								</td>                               
                            </tr>
                            <?php endforeach; ?>                            
                        </tbody>
                    </table>
                    <div style="text-align:center;"><?php echo e($posts->links()); ?></div>
                </div>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->        
    </div>
    <!-- /.col-lg-6 -->
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('template.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>