<!DOCTYPE html>
<!--[if lt IE 7]> <html dir="ltr" lang="en-US" class="ie6"> <![endif]-->
<!--[if IE 7]>    <html dir="ltr" lang="en-US" class="ie7"> <![endif]-->
<!--[if IE 8]>    <html dir="ltr" lang="en-US" class="ie8"> <![endif]-->
<!--[if gt IE 8]><!--> <html dir="ltr" lang="en-US"> <!--<![endif]-->

<!-- BEGIN head -->
<head>

	<!--Meta Tags-->
	<meta name="viewport" content="width=device-width; initial-scale=1.0">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		
	<!--Title-->
	<title>Xuân Phú Hotel - Khách Sạn Xuân Phú Đà Nẵng</title>

	<!--Stylesheets-->
	<link rel="stylesheet" href="<?php echo e(Asset('public/template/css/superfish.css')); ?>" type="text/css"  media="all"  />
	<link rel="stylesheet" href="<?php echo e(Asset('public/template/css/prettyPhoto.css')); ?>" type="text/css" media="all" />
	<link type="text/css"  href="<?php echo e(Asset('public/template/css/jqueryui/jquery.ui.datepicker.css')); ?>" rel="stylesheet" />
	<link rel="stylesheet" href="<?php echo e(Asset('public/template/style.css')); ?>" type="text/css"  media="all"  />
	<link rel="stylesheet" href="<?php echo e(Asset('public/template/css/colours/cream-red.css')); ?>" type="text/css"  media="all"  />
	<link href='http://fonts.googleapis.com/css?family=Cardo:400,400italic,700' rel='stylesheet' type='text/css'>

	<!--Favicon-->
	<link rel="shortcut icon" href="favicon.ico" type="image/x-icon" />

	<!--JavaScript-->
	<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.7/jquery.min.js"></script>
	<script type='text/javascript' src='http://ajax.googleapis.com/ajax/libs/jqueryui/1.8/jquery-ui.min.js'></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/jquery.ui.core.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/jquery.ui.widget.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/jquery.ui.datepicker.js')); ?>"></script>
	<script type='text/javascript' src="<?php echo e(Asset('public/template/js/jquery.prettyPhoto.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/superfish.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/slides.min.jquery.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(Asset('public/template/js/scripts.js')); ?>"></script>
	
	<!--[if (gte IE 6)&(lte IE 8)]>
		<script type="text/javascript" src="js/selectivizr-min.js"></script>
	<![endif]-->

<!-- END head -->
</head>

<!-- BEGIN body -->
<body>

	<!-- BEGIN .background-wrapper -->
	<div class="background-wrapper">
		
		<!-- BEGIN .content-wrapper -->
		<div class="content-wrapper">
		
			<!-- BEGIN .content-body -->
			<div class="content-body">
				
				<!-- BEGIN #header-google-map -->
				<div id="header-google-map" style="display:none;">
					<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=false"></script>
					<script type="text/javascript" src="js/gmap.js"></script>
					<div id="map_canvas" style="width:100%;height:300px;"></div>
				<!-- END #header-google-map -->
				</div>
				
				<!-- BEGIN .top-bar -->
				<div class="top-bar clearfix">
					
					<!-- BEGIN .social-icons -->
					<ul class="social-icons fl">
						<li><a href="https://www.facebook.com/Xuanphuhotel/"><span id="facebook_icon"></span></a></li>
						<li><a href="#"><span id="googleplus_icon"></span></a></li>
						<li><a href="#"><span id="skype_icon"></span></a></li>
						<li><a href="#"><span id="flickr_icon"></span></a></li>
					<!-- END .social-icons -->
					</ul>
					
					<!-- BEGIN .gmap-btn-wrapper -->
					<div class="gmap-btn-wrapper">
						<a href="#" class="gmap-btn"></a>
						<div class="gmap-curve"></div>
					<!-- END .gmap-btn-wrapper -->
					</div>
					
					<!-- BEGIN .top-menu-wrapper -->
					<div class="top-menu-wrapper fr clearfix">
						<a href="<?php echo e(Asset('home/all-room')); ?>" class="bookbutton">ĐẶT PHÒNG</a>
						<!-- <ul class="top-menu fr">
							<li><a href="#">En</a><span> /</span></li>
							<li><a href="#">Fr</a></li>
						</ul> -->
					<!-- END .top-menu-wrapper -->
					</div>
					
				<!-- END .top-bar -->
				</div>
				
				<!-- BEGIN .title-wrapper -->
				<div id="title-wrapper">
					<h1><div class="title-dec-left"></div><a href="<?php echo e(Asset('home/index')); ?>">Xuân Phú Hotel <span>Khách Sạn Xuân Phú</span></a><div class="title-dec-right"></div></h1>
				<!-- END .title-wrapper -->
				</div>
				
				<!-- BEGIN #navigation -->
				<div id="navigation" class="clearfix">
					
					<!-- BEGIN #main-menu -->
					<ul id="main-menu" class="fl clearfix">
						<li><a href="<?php echo e(Asset('home/index')); ?>">Trang chủ<span>start here</span></a></li>
						<li><a href="<?php echo e(Asset('home/all-room')); ?>">Loại phòng<span>rates &amp; reservations</span></a>
							<ul>
								<?php foreach(App\Room::all() as $room): ?>
								<li><a href="<?php echo e(Asset('home/room-detail')); ?>/<?php echo e($room -> id); ?>"><?php echo e($room -> name); ?></a></li>
								<?php endforeach; ?>								
							</ul>
						</li>
						<li><a href="<?php echo e(Asset('home/explore')); ?>">Khám phá Đà Nẵng<span>explore Da Nang</span></a>
							<ul>
								<?php foreach(App\Category::orderBy('id', 'asc') -> take(3) -> get() as $cat): ?>
								<li><a href="<?php echo e(Asset('home/view-by-category')); ?>/<?php echo e($cat->id); ?>"><?php echo e($cat -> name); ?></a></li>
								<?php endforeach; ?>	
							</ul>
						</li>
						<li><a href="<?php echo e(Asset('home/event')); ?>">Khuyến mãi<span>what's happening</span></a></li>
						<li class="current-menu-item"><a href="<?php echo e(Asset('home/contact')); ?>">Liên hệ<span>get in touch</span></a></li>
					<!-- END #main-menu -->
					</ul>
					
					<ul class="main-menu-contact-info fr">
						<li class="info-phone">05113.66.88.16</li>
						<li class="info-email">maixphu@gmail.com</li>
					</ul>
					
					<div class="corner-left"></div>
					<div class="corner-right"></div>
					
				<!-- END #navigation -->
				</div>
				
				<!-- BEGIN .page-header -->
				<div class="page-header">
					<img src="http://themes.quitenicestuff.com/nicehotel/images/pagehead1.jpg" alt="" />
				<!-- END .page-header -->
				</div>
				
				<?php echo $__env->yieldContent('content'); ?>
				
				<!-- BEGIN #footer -->
				<div id="footer" class="clearfix">
					
					<!-- BEGIN .two-forths -->
					<div class="two-forths">
						
						<!-- BEGIN .widget -->
						<div class="widget">
							<div class="widget-title clearfix">
								<h5>Xuân Phú Hotel</h5>
							</div>
							<p>CÔNG TY TNHH MỘT THÀNH VIÊN PHUBK. <br>Mã số doanh nghiệp: 0401741252 <br>06 Hồ Tùng Mậu - phường Hòa Minh, quận Liên Chiểu, TP Đà Nẵng. <br> Phone: 05113.66.88.16 - Email: maixphu@gmail.com</br></p>
						<!-- END .widget -->
						</div>
					
					<!-- END .two-forths -->
					</div>
					
					<!-- BEGIN .one-forth -->
					<div class="one-forth">
						
						<!-- BEGIN .widget -->
						<div class="widget">
							<div class="widget-title clearfix">
								<h5>Liên kết nhanh</h5>
							</div>
							<ul>
								<li><a href="<?php echo e(Asset('home/explore')); ?>">Khám phá Đà Nẵng</a></li>								
								<li><a href="<?php echo e(Asset('home/event')); ?>">Khuyến mãi</a></li>
								<li><a href="<?php echo e(Asset('home/contact')); ?>">Liên hệ</a></li>
							</ul>
						<!-- END .widget -->
						</div>
					
					<!-- END .one-forth -->
					</div>
					
					<!-- BEGIN .one-forth -->
					<div class="one-forth last-col">
						
						<!-- BEGIN .widget -->
						<div class="widget">
							<div class="widget-title clearfix">
								<h5>Hình ảnh</h5>
							</div>
							
							<div class="flickr_badge_wrapper clearfix">
								<script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?count=3&amp;flickr_display=latest&amp;size=s&amp;layout=x&amp;source=user&amp;user=143162021@N04"></script>
								<div style="clear:both;"></div>
								<p class="flickr-more-photos"><a href="http://www.flickr.com/photos/143162021@N04">Xem thêm &raquo;</a></p>
							</div>
						<!-- END .widget -->
						</div>
						
					<!-- END .one-forth -->
					</div>
					
				<!-- END #footer -->
				</div>
				
				<!-- BEGIN #footer-bottom -->
				<div id="footer-bottom" class="clearfix">
					<p class="fl">Copyright by Phubk &copy 2016</p>
					<ul class="footer-menu fr">
						<li><a href="<?php echo e(Asset('home/index')); ?>">Trang chủ</a><span>/</span></li>
						<li><a href="<?php echo e(Asset('home/all-room')); ?>">Đặt phòng</a><span>/</span></li>
						<li><a href="<?php echo e(Asset('home/contact')); ?>">Liên hệ</a><span>/</span></li>
					</ul>
				<!-- END #footer-bottom -->
				</div>
			
			<!-- END .content-body -->
			</div>
			
		<!-- END .content-wrapper -->
		</div>
		
	<!-- END .background-wrapper -->
	</div>

<!-- END body -->
</body>
</html>