

<?php $__env->startSection('title'); ?>
RoomID: <?php echo e($room -> id); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-lg-12">
        <?php if(count($errors) > 0): ?>
            <div class="alert alert-warning" role="alert">
                <?php foreach($errors->all() as $error): ?>
                    <?php echo e($error); ?>

                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <div class="panel panel-default">
            <div class="panel-heading">Edit</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
					<form role="form" method="post" action="<?php echo e(Asset('admin/rooms/edit')); ?>/<?php echo e($room->id); ?>">
						<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
						<div class="form-group">
							<label>Name</label>
							<input class="form-control" name="name" value="<?php echo e($room->name); ?>">
						</div>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>Price</label>
                                    <input class="form-control" name="price" value="<?php echo e($room->price); ?>">
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label>People</label>
                                    <input class="form-control" name="people" value="<?php echo e($room->people); ?>">
                                </div>
                            </div>
                        </div>                        
                        <div class="form-group">
                            <label>Description</label>
                            <textarea class="form-control" rows="5" name="description"><?php echo e($room->description); ?></textarea>
                        </div>
                        <div class="form-group">
                            <label>Image</label>
                            <textarea class="form-control" rows="3" name="image"><?php echo e($room->image); ?></textarea>
                        </div>                        
						<button type="submit" class="btn btn-default">Submit</button>
					</form>
                <!-- /.table-responsive -->
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->    
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('template.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>