<?php $__env->startSection('title'); ?>
<form role="form" method="post" action="<?php echo e(Asset('admin/billings/create')); ?>">
<button type="submit" class="btn btn-warning">BOOKING</button>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="row">
    <div class="col-lg-4">
        <div class="panel panel-default">
            <div class="panel-heading">Rooms</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <table class="table table-hover">
                    <tr class="warning">
                        <th colspan="4">Service</th>                            
                    </tr>
                    <tr>
                        <th>Name</th>
                        <th class="text-center">Qty.</th>
                        <th class="text-center">Price</th>
                        <th class="text-right">Amount</th>
                    </tr>
                    <?php 
                        $count = 0;
                        $totalPayout = 0; 
                        $amount = 0;
                        //$totalPrice = 0; 
                    ?>
                    <?php foreach($customerservices as $cs): ?>
                    <tr>
                        <td><?php echo e(App\Service::find($cs -> service_id)->name); ?></td>
                        <td class="text-center"><?php echo e($cs -> quantity); ?></td>
                        <td class="text-center"><strong><?php echo e($cs -> price); ?></strong></td>
                        <td class="text-right">
                            <?php
                                if($cs -> discount > 0){
                                    $amount = $cs -> quantity*$cs -> price*$cs -> discount*0.1;
                                }else{
                                    $amount = $cs -> quantity*$cs -> price;
                                }
                            ?>
                            <?php echo e($amount); ?>

                        </td>
                    </tr>
                        <?php
                            $count += $cs -> quantity;
                            $totalPayout += $amount; 
                        ?>
                    <?php endforeach; ?>
                    <tr>
                            <th>Total:</th>
                        <th class="text-center"><?php echo e($count); ?></th> 
                        <th class="text-right"></th> 
                        <th class="text-right"><?php echo e(number_format($totalPayout, 0)); ?>$</th>
                    </tr>
                </table>
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>
    <!-- /.col-lg-6 -->
    <div class="col-lg-8">
        <div class="panel panel-default">
            <div class="panel-heading">Rooms</div>
            <!-- /.panel-heading -->
            <div class="panel-body">
                <table class="table table-hover">
                    <tr class="danger">
                        <th colspan="8">Booking</th>                            
                    </tr>
                    <tr>
                        <td>Date From</td>
                        <td>Date To</td>                        
                        <td>Hours</td>
                        <td>Minus</td>
                        <td>Rooms</td>
                        <td>Price</td>
                        <td>Amount</td>
                    </tr>
                    <?php for($i = 0; $i < sizeof($days)-1; $i++): ?>
                    <tr>
                        <td><?php echo e(current($days)); ?></td>
                        <td><?php echo e(next($days)); ?></td>
                        <?php
                                $hour_from = strtotime(date("H:i:s", strtotime($days[$i])));
                                $hour_to   = strtotime(date("H:i:s", strtotime($days[$i+1])));

                                if(($hour_to - $hour_from) > 0){
                                    $distance = ($hour_to - $hour_from);                           
                                }else{
                                    $distance = 86400 + $hour_to - $hour_from;
                                }

                                $hour = floor($distance/3600);
                                $minus = floor($distance/60)%60;

                                $price = array();
                                $price[0] = 0;

                                if($hour < 1){
                                    $price_hour[0] = 0;

                                    if($minus > 5 && $minus < 30){
                                        $price[0] = 50;
                                    }
                                    if($minus >= 30 && $minus < 60){
                                        $price[0] = 60;
                                    }
                                }else if($hour == 1 && $hour < 7 ){
                                   /* $price[0] = 60;
                                    for ($i=1; $i < $hour ; $i++) {
                                        $price[$i] = 20;                                  
                                    }
                                    $end = sizeof($price);
                                    if($minus < 30){                                        
                                        $price[$end+1] = 10;
                                    }else{                                        
                                        $price[$end+1] = 20;
                                    }*/
                                }else if($hour >=7 && $hour <=12){
                                    $price[0] = 160;
                                }else{
                                    $price[0] = $invoice[0] -> price;
                                }  
                                /*echo "<pre>";
                                var_dump($price);
                                echo "</pre>";    */                       
                        ?>                        
                        <td><?php if($hour < 10): ?> <strong>0<?php echo e($hour); ?></strong> <?php else: ?> <strong><?php echo e($hour); ?></strong> <?php endif; ?></td>
                        <td><?php if($minus < 10): ?> <strong>0<?php echo e($minus); ?></strong> <?php else: ?> <strong><?php echo e($minus); ?></strong> <?php endif; ?></td>
                        <td>P<?php echo e(App\Item::find($invoice[0] -> item_id)->name); ?></td>
                        <td><?php echo e(array_sum($price)); ?></td>
                        <td></td>
                    </tr>
                    <?php endfor; ?>                    
                </table>
            </div>
            <!-- /.panel-body -->
        </div>
        <!-- /.panel -->
    </div>    
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('template.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>