<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Event;
use Validator;
use App\Room;
use App\Order;
use App\Roomfacility;
use App\Contact;

class HomeController extends Controller
{
    public function getIndex(){
    	return view('home.index');
    } 
    
    public function getRoomDetail($id){
        $current = Room::find($id);
        $images = explode(';', $current -> image);

        $roomfacilities = Roomfacility::where('room_id', $id) -> where('active', 1) ->get();
        $count = $roomfacilities -> count();
              
        $left = Roomfacility::where('room_id', $id) -> where('active', 1) ->take(ceil($count/3)) -> get();
        $center = Roomfacility::where('room_id', $id) -> where('active', 1) ->skip(ceil($count/3))->take(ceil($count/3)) -> get();

        $skip = $left -> count() + $center -> count();
        $limit = $count - $skip;
        $right = Roomfacility::where('room_id', $id) -> where('active', 1) ->skip($skip)->take($limit) -> get();

        return view('home.roomdetail')
            ->with('current', $current)
            ->with('images', $images)
            ->with('roomfacilities', $roomfacilities)
            ->with('center',$center)
            ->with('left', $left)
            ->with('right', $right);
    }

    public function getBooking(Request $request){
        $id = $request -> roomId;
        $roomType = Room::find($id)->name;
        $price = $request -> price;
        $datefrom = $request -> datefrom;
        $dateto = $request ->dateto;

        $datediff = abs(strtotime($dateto) - strtotime($datefrom));
        return view('home.booking')
            ->with('roomType', $roomType)
            ->with('price', $price)
            ->with('datefrom', $datefrom)
            ->with('dateto', $dateto)
            ->with('kc', floor($datediff / (60*60*24)))
            ->with('id', $id);
    }


    public function getBookingIndex(Request $request){
        $datefrom = $request -> datefrom;
        $dateto = $request ->dateto;

        $price = Room::find($request->room_id) -> price;
        $roomType = Room::find($request->room_id)->name;
        $datediff = abs(strtotime($dateto) - strtotime($datefrom));

        return view("home.booking")
            ->with("datefrom", $datefrom)
            ->with('dateto', $dateto)
            ->with('roomType', $roomType)
            ->with('price', $price)
            ->with('kc', floor($datediff / (60*60*24)))
            ->with('id',$request->room_id);
    }


    public function postOrder(Request $request){
        $validator = Validator::make($request->all(), [
            'people' => 'required|integer',
            'fullname' => 'required',
            'email' => 'required|email',
        ]);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }

        $order = new Order;
        $order -> room_id = $request -> roomId;
        $order -> datefrom = date('Y-m-d H:i:s', strtotime($request -> datefrom)); 
        $order -> dateto = date('Y-m-d H:i:s', strtotime($request -> dateto)); 
        $order -> fullname = $request -> fullname;
        $order -> people = $request -> people;
        $order -> email = $request -> email;
        $order -> phone = $request -> phone;
        $order -> message = $request -> message;
        $order -> save();
        return back() ->withErrors('Yêu cầu đặt phòng của bạn đã được gửi đi. Xin cảm ơn !');;
    }

    public function getAllRoom(){
        $rooms = Room::orderBy('price', 'asc') -> paginate(3);
        $left = Room::all()->random(1);
        $right = Room::all()->random(1);
        $center  = Room::orderBy('people', 'desc')->first();

        $image_left = explode(';', $left -> image);
        $image_right = explode(';', $right -> image);
        $image_center = explode(';', $center -> image);

        return view('home.rooms')
            ->with('rooms', $rooms)
            ->with('left', $left) ->with('image_left', $image_left[0])
            ->with('right',$right) ->with('image_right', $image_left[0])
            ->with('center', $center) ->with('image_center', $image_center[0]);
    }

    public function getReason(){
        return view("home.reason")
            ->with('title', "Lý do chọn Xuân Phú Hotel?");
    }    
}
